/** @file   GuardianTankController.cpp
 * @brief   Implementation of GuardianTankController class.
 * @version $Revision: 1.1 $
 * @date    $Date: 2006/03/29 22:26:21 $
 * @author  Tomi Lamminsaari
 */

#include "GuardianTankController.h"
#include "WarGlobals.h"
#include "www_map.h"
using eng2d::Vec2D;

namespace WeWantWar {

///
/// Constants, datatypes and static methods
/// ============================================================================




///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
GuardianTankController::GuardianTankController( GameObject* aObject ) :
  WaypointController( aObject )
{
}



/** Destructor.
 */
GuardianTankController::~GuardianTankController()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

void GuardianTankController::update()
{
  m_counter -= 1;
  if ( m_counter > 0 ) {
    return;
  }
  if ( this->validRoute() == false ) {
    this->reset();
    m_counter = 20;
    return;
  }
  if ( this->waypointReached() == true ) {
    this->step();
  }
  this->reset();
  if ( this->canSeeTarget() ) {
    m_shoot = 1;
    m_counter = 10;
    return;
  }
  
  if ( this->isFacingWaypoint(20) == true ) {
    m_forward = 1;
    m_counter = 4;
    
  } else {
    m_forward = 1;
    m_turn = this->findShortestTurn();
    m_counter = 2;
    
  }
}




///
/// New public methods
/// ============================================================================

void GuardianTankController::setAttackRange( float aRange )
{
  iAttackRange = aRange;
}



///
/// Getter methods
/// ============================================================================




///
/// Protected and private methods
/// ============================================================================

bool GuardianTankController::canSeeTarget() const
{
  GameObject* player = WarGlobals::pObjTable->pPlayer;
 
  Vec2D targetPos( player->position() );

  // Create a directionvector from the alien to target.
  Vec2D dirVec( targetPos );
  dirVec -= this->getGameObject()->position();

  // Are we further than max visual range from the target.
  float distance = dirVec.length();
  if ( distance > iAttackRange ) {
    return false;
  }
  
  int dist2 = static_cast<int>( distance );
  dirVec.norm();
  dirVec.scale( 8 );


  Vec2D tmpPos( this->getGameObject()->position() );
  for (int i=0; i < dist2; i++) {
    tmpPos += dirVec;
    Vec2D fooV( targetPos );
    fooV -= tmpPos;
    if ( fabs(fooV.vx) < 16 && fabs(fooV.vy) < 16 ) {
      return true;
    }
    if ( Map::bulletCollide(tmpPos) == true ) {
      return false;
    }
  }
  return false;
}


};  // end of namespace
